
MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN			: origin = 0x000000, length = 0x000002
   RAMM0			: origin = 0x000200, length = 0x000200
   RAMLSD          	: origin = 0x008000, length = 0x004000
   RESET           	: origin = 0x3FFFC0, length = 0x000002

PAGE 1 :

   BOOT_RSVD		: origin = 0x000002, length = 0x000120     /* Part of M0, BOOT rom will use this for stack */
   RAMM1			: origin = 0x000122, length = 0x0006DE     /* on-chip RAM block M0/M1 */

   RAMGS			: origin = 0x00C000, length = 0x010000

   CANA_MSG_RAM		: origin = 0x049000, length = 0x000800
   CANB_MSG_RAM		: origin = 0x04B000, length = 0x000800

   CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   : origin = 0x03FC00, length = 0x000400
}


SECTIONS
{
   codestart        : > BEGIN,     PAGE = 0
   .text            : > RAMLSD,   PAGE = 0
   .cinit           : > RAMGS,     PAGE = 1
   .pinit           : > RAMGS,     PAGE = 1
   .switch          : > RAMGS,     PAGE = 1
   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */

   .stack           : > RAMM1,     PAGE = 1
   .ebss            : > RAMGS,     PAGE = 1
   .econst          : > RAMGS,     PAGE = 1
   .esysmem         : > RAMGS,     PAGE = 1
   .cio		        : > RAMGS,     PAGE = 1
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
